/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.blocks.AbstractBlockBarrel;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.types.BarrelType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.coremod.compatibility.jei.RenderHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CompostRecipeCategory
implements IRecipeCategory<CompostRecipe> {
    private final String title = new TranslatableComponent(ModBlocks.blockBarrel.m_7705_()).getString();
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final ITickTimer timer;

    public CompostRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(80, 50);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack(ModBlocks.blockBarrel));
        this.slot = guiHelper.getSlotDrawable();
        this.timer = guiHelper.createTickTimer(60, BarrelType.values().length - 2, false);
    }

    @NotNull
    public static List<CompostRecipe> findRecipes() {
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfCompostRecipes().entrySet().stream().map(entry -> CompostRecipe.individualize((Item)entry.getKey(), (CompostRecipe)entry.getValue())).collect(Collectors.toList());
    }

    @NotNull
    public ResourceLocation getUid() {
        return CompostRecipe.ID;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public Class<? extends CompostRecipe> getRecipeClass() {
        return CompostRecipe.class;
    }

    @NotNull
    public Component getTitle() {
        return new TextComponent(this.title);
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull CompostRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 0, 0).setBackground(this.slot, -1, -1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 62, 0).setBackground(this.slot, -1, -1).addItemStack(recipe.m_8043_());
    }

    public void draw(@NotNull CompostRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull PoseStack stack, double mouseX, double mouseY) {
        BarrelType type = BarrelType.byMetadata(this.timer.getValue());
        BlockState barrel = (BlockState)((BlockState)ModBlocks.blockBarrel.m_49966_().m_61124_((Property)AbstractBlockBarrel.FACING, (Comparable)Direction.SOUTH)).m_61124_(AbstractBlockBarrel.VARIANT, (Comparable)((Object)type));
        RenderHelper.renderBlock(stack, barrel, 40.0f, 20.0f, 100.0f, -30.0f, 20.0f, 25.0f);
    }
}

